﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Percent___Qualification_work.Classes
{
    public class Movie
    {
        public int? Id { get; set; }             // Nullable ID of the movie (optional when adding a new movie)
        public string Name { get; set; }       // Title of the movie
        public string Genre { get; set; }       // Genre of the movie
        public string Director { get; set; }    // Director of the movie
        public int ReleaseYear { get; set; }    // Release year of the movie
        public byte[] CoverImage { get; set; }  // BLOB for the cover image of the movie
        public Movie(int? id, string name, string genre, string director, int releaseYear, byte[] coverImage)
        {
            Id = id;
            Name = name;
            Genre = genre;
            Director = director;
            ReleaseYear = releaseYear;
            CoverImage = coverImage;
        }

        public override string ToString()
        {
            return $"Is this the movie you want to add?\n" +
                   $"Title: {Name}\n" +
                   $"Genre: {Genre}\n" +
                   $"Director: {Director}\n" +
                   $"Release Year: {ReleaseYear}";
        }
    }
}
